package com.tll.inspect.rpc.dto;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 巡检模板查询参数
 *
 * @author zhaoshuai
 * @date 2025-05-21 9:20
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class InspectTemplateDTO extends AbstractExportQueryParam implements Serializable {

    private static final long serialVersionUID = 124411054825386318L;

    @ApiModelProperty("巡检项id")
    private Long itemId;

    @ApiModelProperty("表单id")
    private Long formId;

    @ApiModelProperty("表单id列表")
    private List<Long> formIds;

}
