package com.tll.inspect.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.inspect.Application;
import com.tll.inspect.rpc.dto.SignInViewDTO;
import com.tll.inspect.rpc.dto.signin.SignInAddDTO;
import com.tll.inspect.rpc.dto.signin.SignInAppPageDTO;
import com.tll.inspect.rpc.dto.signin.SignInEditDTO;
import com.tll.inspect.rpc.dto.signin.SignInRecordDTO;
import com.tll.inspect.rpc.vo.SignInViewVO;
import com.tll.inspect.rpc.vo.signin.SignInAppPageVO;
import com.tll.inspect.rpc.vo.signin.SignInRecordListVO;
import com.tll.inspect.rpc.vo.signin.SignInRecordVO;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author XieBeiChen
 * @date 2025-06-05 11:23
 * @description
 */
@FeignClient(name = Application.NAME, path = SignInRpcService.URI)
public interface SignInRpcService {

    String URI = Application.URI_PREFIX + "/signIn";
    /**
     * 签到记录添加(每日签到)
     * @param dto
     * @return
     */
    @PostMapping("/add")
    ApiResult<Void> add(@Valid @RequestBody SignInAddDTO dto);

    /**
     * 签到记录编辑
     * @param dto
     * @return
     */
    @PostMapping("/edit")
    ApiResult<Void> edit(@Valid @RequestBody SignInEditDTO dto);

    /**
     * 签到记录： 当前用户以及当前用户子用户
     * @param dto
     * @return
     */
    @PostMapping("/records")
    ApiResult<SignInRecordVO> records(@RequestBody SignInRecordDTO dto);

    /**
     * 签到记录,详情信息
     * @param dto
     * @return
     */
    @PostMapping("/pageForApp")
    @ApiOperation("签到记录")
    ApiResult<PagingVO<SignInAppPageVO>> pageForApp(@RequestBody SignInAppPageDTO dto);


    /**
     * 签到数据标识  日期标识是否有签到数据
     * @param dto
     * @return
     */
    @PostMapping("/view")
    @ApiOperation("签到数据标识")
    ApiResult<SignInViewVO> view(@Valid @RequestBody SignInViewDTO dto);
}
