package com.tll.inspect.rpc.dto;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * @author  XieBeiChen
 * @date  2025-06-12 13:44
 * @description
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ReportSubmitDTO implements Serializable {

    @ApiModelProperty(value = "报告id",required = true)
    @NotNull(message = "报告id不能为空")
    private Long reportId;

    @ApiModelProperty("强制签退时实际离店时间")
    private LocalDateTime actualLeaveTime;

    @ApiModelProperty("最晚整改配置天数")
    private Integer maxRectificationDays;

}
