package com.tll.inspect.rpc.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.persistence.Column;
import lombok.Data;

/**
 * 员工任务表单项内容详情
 *
 * @author Jxinx
 * @date 2024-09-13
 */
@Data
public class EmployeeTaskItemOptionDetailVO implements Serializable {

    @Comment("记录唯一ID")
    @ApiModelProperty("记录唯一ID")
    private Long id;

    @Comment("所属表单项id")
    @ApiModelProperty("所属表单项id")
    private long formItemId;

    @Comment("排序号")
    @ApiModelProperty("排序号")
    private int sort;

    @Comment("选项内容")
    @ApiModelProperty("选项内容")
    private String content;


    @Comment("表单项对应选项或值")
    @ApiModelProperty("表单项对应选项或值")
    private String optionValue;

    @Comment("量表分值")
    @ApiModelProperty("量表分值")
    private Integer levelNum;
    
    @Comment("是否存在图片：0-不存在，1-存在")
    @ApiModelProperty("是否存在图片：0-不存在，1-存在")
    private Integer existPicture;


}
