package com.tll.inspect.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.inspect.Application;
import com.tll.inspect.rpc.dto.travel.TravelDeleteSubmitRpcDTO;
import com.tll.inspect.rpc.dto.travel.TravelUpdateSubmitRpcDTO;
import com.tll.inspect.rpc.vo.TravelChangeSubmitRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = Application.NAME, path = TravelAuditRpcService.URI)
@Validated
public interface TravelAuditRpcService {

    String URI = Application.URI_PREFIX + "/travel/audit";

    @PostMapping("/updateSubmit")
    @ApiOperation("行程编辑提交审核")
    ApiResult<TravelChangeSubmitRpcVO> updateSubmit(@RequestBody TravelUpdateSubmitRpcDTO dto);

    @PostMapping("/deleteSubmit")
    @ApiOperation("行程删除提交审核")
    ApiResult<TravelChangeSubmitRpcVO> deleteSubmit(@RequestBody TravelDeleteSubmitRpcDTO dto);
}