package com.tll.inspect.rpc.dto.travel;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 行程门店列表查询参数
 * @author zhaoshuai
 * @date 2025/6/6
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class StoreListQueryRpcDTO extends AbstractExportQueryParam {


    private static final long serialVersionUID = 8328851409422195027L;
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("userId")
    private String userId;

    @ApiModelProperty(value = "登记人id")
    private String registrantId;

    @ApiModelProperty("门店编号/门店名称/法人姓名/法人手机号")
    private String storeDetail;

    @ApiModelProperty("省ID列表")
    private List<String> province;

    @ApiModelProperty("市ID列表")
    private List<String> city;

    @ApiModelProperty("区ID列表")
    private List<String> district;

    @ApiModelProperty("运营状态： 0：签约、1：营业中、2：短期闭店、3：空合同、4：到期解约、5：长期闭店、7：待装修、8：强制解约、9：其它解约 ")
    private Integer operationStatus;

    @ApiModelProperty("门店类型： 1：加盟店  0：直营店")
    private Integer storeType;

    @ApiModelProperty(value = "经度")
    private double longitude;

    @ApiModelProperty(value = "纬度")
    private double latitude;

    @ApiModelProperty("法人")
    private String legalPerson;

    @ApiModelProperty("法人电话")
    private String legalPersonPhone;

    @ApiModelProperty("员工姓名")
    private String staffName;

    @ApiModelProperty(value = "特殊处理(控制返回数据是否排序)")
    private Boolean special = false;

    @ApiModelProperty(value = "权限开关处理")
    private Boolean permission = false;

    @ApiModelProperty(value = "门店法人组合查询(输入门店法人姓名或手机号查询)")
    private String storeLegalPerson;

    @ApiModelProperty(value = "门店信息组合信息查询(门店编码或门店名称查询)")
    private String storeInfo;

    @ApiModelProperty(value = "查询参数")
    private String keyword;

    @ApiModelProperty(value = "门店编码列表")
    private List<String> storeCodes;

    @ApiModelProperty("仅看30天内无到店巡检的门店")
    private Boolean onlyNoThirty;

    @ApiModelProperty("是否过滤解约的门店(true过滤 false不过滤)")
    private Boolean filterTermination = false;

}
