package com.tll.inspect.rpc.vo.signin;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-07-23 10:42
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SignInRecordListVO implements Serializable {

    @ApiModelProperty(value = "用户id")
    private Long userId;

    @ApiModelProperty("用户名")
    private String userName;

    @ApiModelProperty(value = "员工完整部门id")
    private String userFullOrgId;

    @ApiModelProperty(value = "员工完整部门名称")
    private String userFullOrgName;

    @ApiModelProperty(value = "行程数据")
    private List<TravelVO> travelList;

    @ApiModelProperty("最后一次提醒时间")
    private LocalDateTime lastRemindTime;

    @ApiModelProperty(name = "行程类型：0-其他，1-赶路，2-返程，3-活动到店，4-巡检到店，5-休假")
    private Set<Integer> travelTypes;

    @ApiModelProperty("签到项列表")
    private List<SignItemVO> signList;

    @ApiModelProperty("是否已提醒")
    private Boolean remind = false;

}
