package com.tll.inspect.rpc.vo.signin;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-07-23 10:56
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SignItemVO {

    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("打卡类型:1-打卡，2-到店签到，3-离店签退")
    private Integer source;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty(value = "备注")
    private String remark;
}
