package com.tll.inspect.rpc.dto.communication;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 沟通记录查询参数
 *
 * @author Jxinx
 * @since 2025-06-16
 */
@Data
@ApiModel(description = "沟通记录查询参数")
public class CommunicationRecordQueryRpcDTO extends AbstractExportQueryParam {

    private static final long serialVersionUID = 9176033324543227316L;

    /**
     * 门店名称/门店编码
     */
    @ApiModelProperty(value = "门店名称/门店编码")
    private String storeDetail;

    /**
     * 法人/法人手机号
     */
    @ApiModelProperty(value = "法人/法人手机号")
    private String legalPerson;

    /**
     * 门店关键词
     */
    @ApiModelProperty(value = "门店关键词")
    private String storeKeyword;

    /**
     * 沟通渠道，UDC 巡检，线下，微信，电话，其他
     */
    @ApiModelProperty(value = "沟通渠道，UDC 巡检，线下，微信，电话，其他")
    private String channel;

    /**
     * 岗位名称
     */
    @ApiModelProperty(value = "岗位名称")
    private String positionName;

    /**
     * 沟通时间-起始时间
     */
    @ApiModelProperty(value = "沟通时间-起始时间")
    private LocalDateTime communicationTimeStart;

    /**
     * 沟通时间-截止时间
     */
    @ApiModelProperty(value = "沟通时间-截止时间")
    private LocalDateTime communicationTimeEnd;

    /**
     * 沟通人
     */
    @ApiModelProperty(value = "沟通人")
    private String creator;

    /**
     * 门店区域
     */
    @ApiModelProperty(value = "门店区域")
    private List<Long> storeAreaList;

    /**
     * 门店省市区
     */
    @ApiModelProperty(value = "门店省市区")
    private List<String> provincesAndCities;

    @ApiModelProperty(value = "门店编码")
    private String storeCode;

}
