package com.tll.inspect.rpc.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author XieBeiChen
 * @date 2025-07-09 15:20
 * @description
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ReportSubListVO {

    @ApiModelProperty("角色(岗位名称)")
    private String role;

    @ApiModelProperty("角色类型")
    private Integer roleType;

    @ApiModelProperty("统计数据")
    private List<ReportSubListItemVO> items;

    @ApiModelProperty("报告分析")
    private List<ReportAnalysisVO> analysis;

    @ApiModelProperty("整改状态统计")
    private List<RectificationStatusChartVO> rectificationStatusChart;

    @ApiModelProperty("整改逾期统计")
    private List<RectificationOverdueChartVO> rectificationOverdueChart;

    @ApiModelProperty("巡检项不合格排行")
    private List<UnqualifiedRankVO> ranks;
}
