package com.tll.inspect.rpc.vo.communication;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 沟通记录列表响应实体数据
 *
 * @author Jxinx
 * @since 2025-07-12
 */
@Data
@ApiModel(description = "沟通记录列表响应实体数据")
public class CommunicationRecordPageRespRpcVO implements Serializable {

    private static final long serialVersionUID = 3282039006217782598L;

    /**
     * 记录唯一ID
     */
    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称")
    private String storeName;

    /**
     * 法人
     */
    @ApiModelProperty(value = "法人")
    private String legalPerson;

    /**
     * 法人手机号
     */
    @ApiModelProperty(value = "法人手机号")
    private String legalPhone;

    /**
     * 沟通渠道，UDC 巡检，线下，微信，电话，其他
     */
    @ApiModelProperty(value = "沟通渠道，UDC 巡检，线下，微信，电话，其他")
    private String channel;
    /**
     * 沟通渠道名称
     */
    private String channelName;

    /**
     * 岗位名称
     */
    @ApiModelProperty(value = "岗位名称")
    private String positionName;

    /**
     * 沟通时间
     */
    @ApiModelProperty(value = "沟通时间")
    private LocalDateTime communicationTime;

    /**
     * 沟通内容
     */
    @ApiModelProperty(value = "沟通内容")
    private String content;

    /**
     * 附件列表
     */
    @ApiModelProperty(value = "附件列表")
    private String fileUrls;

    /**
     * 巡检任务编码
     */
    @ApiModelProperty(value = "巡检任务编码")
    private String inspectTaskNumber;

    /**
     * 沟通人ID
     */
    @ApiModelProperty(value = "沟通人ID")
    private Long createUserId;

    /**
     * 沟通人姓名
     */
    @ApiModelProperty(value = "沟通人姓名")
    private String creator;

    /**
     * 督导姓名
     */
    @ApiModelProperty(value = "督导")
    private String areaManager;

    /**
     * 督导id
     */
    @ApiModelProperty(value = "督导id")
    private String areaManagerId;

    /**
     * 区域经理姓名
     */
    @ApiModelProperty(value = "区域经理")
    private String provinceManager;

    /**
     * 区域经理id
     */
    @ApiModelProperty(value = "区域经理id")
    private String provinceManagerId;

    /**
     * 省经理姓名
     */
    @ApiModelProperty(value = "省经理")
    private String regionManager;

    /**
     * 省经理id
     */
    @ApiModelProperty(value = "省经理id")
    private String regionManagerId;

    /**
     * 战区
     */
    @ApiModelProperty(value = "战区")
    private String warArea;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;
}
