package com.tll.inspect.constant;

/**
 * 行程审核状态（-1无/未提交 0已提交/审核中 1审核通过 2审核驳回）
 */
public enum TravelAuditStatusEnum {

    NONE(-1,"未提交"),
    SUBMIT(0,"审核中"),
    PASS(1,"审核通过"),
    REJECT(2,"审核驳回");

    private Integer code;

    private String desc;

    TravelAuditStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(Integer code) {
        for (TravelAuditStatusEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type.getDesc();
            }
        }
        return null;
    }

    public static Integer getCodeByDesc(String desc) {
        for (TravelAuditStatusEnum type : values()) {
            if (type.getDesc().equals(desc)) {
                return type.getCode();
            }
        }
        return null;
    }

    public static TravelAuditStatusEnum getEnumByCode(Integer code) {
        for (TravelAuditStatusEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

}
