package com.tll.inspect.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.inspect.Application;
import com.tll.inspect.rpc.dto.communication.CommunicationRecordDetailQueryRpcDTO;
import com.tll.inspect.rpc.dto.communication.CommunicationRecordQueryRpcDTO;
import com.tll.inspect.rpc.dto.communication.CommunicationRecordsSaveRpcDTO;
import com.tll.inspect.rpc.vo.UnifiedReturnRpcVO;
import com.tll.inspect.rpc.vo.communication.CommunicationRecordDetailRpcVO;
import com.tll.inspect.rpc.vo.communication.CommunicationRecordPageRespRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 沟通记录Rpc接口
 *
 * @author Jxinx
 * @since 2025-07-12
 */
@FeignClient(name = Application.NAME, path = CommunicationRecordRpcService.URI)
public interface CommunicationRecordRpcService {

    String URI = Application.URI_PREFIX + "/api/communicationRecord";

    @PostMapping(value = "/page")
    @ApiOperation(value = "分页查询沟通记录")
    ApiResult<PagingVO<CommunicationRecordPageRespRpcVO>> pageQuery(@RequestBody CommunicationRecordQueryRpcDTO queryDTO);

    @PostMapping("/save")
    @ApiOperation("保存沟通记录")
    ApiResult<UnifiedReturnRpcVO> save(@RequestBody @Valid CommunicationRecordsSaveRpcDTO rpcDTO);

    @PostMapping("/detail")
    @ApiOperation("沟通记录详情")
    ApiResult<CommunicationRecordDetailRpcVO> detail(@RequestBody @Valid CommunicationRecordDetailQueryRpcDTO rpcDTO);

}
