package com.tll.inspect.rpc.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.LinkedHashSet;

/**
 * RPC分页查询继承基类
 * @author zhaoshuai
 * @date 2025/7/16
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RpcQueryParam implements Serializable {

    private static final long serialVersionUID = -1973217644683019704L;

    @ApiModelProperty(
            value = "页码",
            example = "1"
    )
    public Integer current = 1;
    @ApiModelProperty(
            value = "页大小",
            example = "10"
    )
    public Integer size = 10;
    @ApiModelProperty("搜索内容")
    private String keyword;
    @ApiModelProperty("ID")
    private LinkedHashSet<Long> idSet;
}
