package com.tll.inspect.rpc.vo.travel;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 行程管理
 * @author zhaoshuai
 * @date 2025/6/11
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TravelRpcVO implements Serializable {

    @ApiModelProperty("行程id")
    private Long id;

    @ApiModelProperty(value = "行程类型（0其他 1赶路 2返程 3活动到店 4门店巡检 5休假）")
    private Integer travelType;

    @ApiModelProperty(value = "行程执行人id")
    private Long executeUserId;
    @ApiModelProperty(value = "行程执行人姓名")
    private String executeUserName;
    @ApiModelProperty(value = "执行人岗位名称")
    private String executeUserPositionName;

    @ApiModelProperty(value = "执行人部门id（全路径）")
    private String executeUserDeptId;
    @ApiModelProperty(value = "执行人部门名称（全路径）")
    private String executeUserDeptName;

    @ApiModelProperty("请假单id")
    private String vacationId;
    @ApiModelProperty("请假类型")
    private String vacationType;
    @ApiModelProperty("请假类型")
    private String vacationTypeName;
    @ApiModelProperty("请假状态")
    private Integer vacationStatus;

    @ApiModelProperty("行程日期（yyyy-MM-dd）")
    private String travelDate;

    @ApiModelProperty("日期范围类型(0全天 1上半天 2 下半天)")
    private Integer dateRangeType;

    @ApiModelProperty(value = "开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "出发省编码")
    private String fromProvinceCode;

    @ApiModelProperty(value = "出发省名称")
    private String fromProvinceName;

    @ApiModelProperty("出发市编码")
    private String fromCityCode;

    @ApiModelProperty("出发市名称")
    private String fromCityName;

    @ApiModelProperty(value = "目的地省编码")
    private String toProvinceCode;

    @ApiModelProperty(value = "目的地省名称")
    private String toProvinceName;

    @ApiModelProperty("目的地市编码")
    private String toCityCode;

    @ApiModelProperty("目的地市名称")
    private String toCityName;

    @ApiModelProperty("具体明细")
    private String detail;

    @ApiModelProperty("行程说明")
    private String description;

    @ApiModelProperty("审核状态(-1无/未提交 0审核中 1审核通过 2审核驳回)")
    private Integer auditStatus;

    @ApiModelProperty(value = "流程id")
    private String auditProcessId;

    @ApiModelProperty(value = "审核提交备注")
    private String auditDescription;

    @ApiModelProperty(value = "原行程id")
    private Long auditSourceTravelId;

    @ApiModelProperty(value = "行程删除标识")
    private Boolean auditDeleteFlag;

    @ApiModelProperty("行程门店")
    private List<TravelStoreRpcVO> storeVOS;
}
