package com.tll.inspect.rpc.dto.communication;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 沟通记录归档请求参数
 *
 * @author Jxinx
 * @since 2025-08-27
 */
@Data
@ApiModel(description = "沟通记录归档请求参数")
public class CommunicationRecordArchiveRpcDTO implements Serializable {

    private static final long serialVersionUID = -6085172975420809764L;

    /**
     * 记录id
     */
    @NotNull(message = "记录id不能为空")
    @ApiModelProperty(value = "记录id")
    private Long id;

    /**
     * 归档说明
     */
    @ApiModelProperty(value = "归档说明")
    private String archiveRemark;

}
