package com.tll.inspect.rpc.vo.communication;

import com.tll.inspect.rpc.vo.media.MediaVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 沟通记录详情响应实体数据
 *
 * @author Jxinx
 * @since 2025-07-12
 */
@Data
@ApiModel(description = "沟通记录详情响应实体数据")
public class CommunicationRecordDetailRpcVO implements Serializable {

    private static final long serialVersionUID = -2945240933182141716L;

    /**
     * 记录唯一ID
     */
    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称")
    private String storeName;

    /**
     * 法人
     */
    @ApiModelProperty(value = "法人")
    private String legalPerson;

    /**
     * 法人手机号
     */
    @ApiModelProperty(value = "法人手机号")
    private String legalPhone;

    /**
     * 沟通渠道，UDC 巡检，线下，微信，电话，其他
     */
    @ApiModelProperty(value = "沟通渠道，UDC 巡检，线下，微信，电话，其他")
    private String channel;
    /**
     * 沟通渠道名称
     */
    private String channelName;

    /**
     * 岗位名称
     */
    @ApiModelProperty(value = "岗位名称")
    private String positionName;

    /**
     * 沟通时间
     */
    @ApiModelProperty(value = "沟通时间")
    private LocalDateTime communicationTime;

    /**
     * 沟通内容
     */
    @ApiModelProperty(value = "沟通内容")
    private String content;

    /**
     * 沟通状态：0-沟通中，1-已归档
     */
    @ApiModelProperty(value = "沟通状态：0-沟通中，1-已归档")
    private Integer status;

    /**
     * 归档人id
     */
    @ApiModelProperty(value = "归档人id")
    private Long archiveUserId;

    /**
     * 归档人姓名
     */
    @ApiModelProperty(value = "归档人姓名")
    private String archiveUserName;

    /**
     * 归档人岗位
     */
    @ApiModelProperty(value = "归档人岗位")
    private String archiveUserDuty;

    /**
     * 归档时间
     */
    @ApiModelProperty(value = "归档时间")
    private LocalDateTime archiveTime;

    /**
     * 归档说明
     */
    @ApiModelProperty(value = "归档说明")
    private String archiveRemark;

    /**
     * 附件列表
     */
    @ApiModelProperty(value = "附件列表")
    private List<MediaVO> fileUrls;

    /**
     * 附件url字符串
     */
    @ApiModelProperty(value = "附件url字符串")
    private String fileUrlStrs;

    /**
     * 巡检任务编码
     */
    @ApiModelProperty(value = "巡检任务编码")
    private String inspectTaskNumber;

    /**
     * 巡检报告id
     */
    @ApiModelProperty(value = "巡检报告id")
    private Long inspectReportId;

    /**
     * 沟通人ID
     */
    @ApiModelProperty(value = "沟通人ID")
    private Long createUserId;

    /**
     * 沟通人姓名
     */
    @ApiModelProperty(value = "沟通人姓名")
    private String creator;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

}
