package com.tll.inspect.rpc.vo.report;

import com.tll.inspect.rpc.dto.ModuleGroupDTO;
import com.tll.inspect.rpc.vo.FormDetailVO;
import com.tll.inspect.rpc.vo.signin.SignInListVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 巡检报告返回
 *
 * @author zhaoshuai
 * @date 2025/6/18
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel(description = "巡检报告详情返回")
public class InspectReportOverViewRpcVO implements Serializable {

    private static final long serialVersionUID = 2459763293578471272L;

    @ApiModelProperty("巡检报告id")
    private Long id;

    @ApiModelProperty("是否合格（1-合格，0-不合格）")
    private Boolean passFlag;

    @ApiModelProperty(value = "不合格类型 0-无，1-否决项不合格")
    private Integer unqualifiedType;

    @ApiModelProperty("巡检人")
    private String executor;

    @ApiModelProperty("职位")
    private String executeUserPositionName;

    @ApiModelProperty("门店编号）")
    private String storeCode;

    @ApiModelProperty("门店名称）")
    private String storeName;

    @ApiModelProperty("巡检总分（包含加分项、减分项）")
    private BigDecimal totalScore;

    @ApiModelProperty("巡检报告得分")
    private BigDecimal score;

    @ApiModelProperty("巡检日期（报告提交日期）")
    private String commitTime;

    //x小时x分x秒， 报告提交时间-到店签到时间
    @ApiModelProperty("巡检日期（报告提交日期）")
    private String inspectCostTime;

    @ApiModelProperty("巡检报告总结")
    private String reportSummary;

    @ApiModelProperty("巡检项加分")
    private BigDecimal addScoreSum = BigDecimal.ZERO;

    @ApiModelProperty("巡检项减分")
    private BigDecimal deductScoreSum = BigDecimal.ZERO;

    @ApiModelProperty("签到记录")
    private SignInListVO signIn;

    @ApiModelProperty("签退记录")
    private SignInListVO signOut;

    @ApiModelProperty("一般项")
    private Integer normalNum = 0;

    @ApiModelProperty("红线项")
    private Integer redLineNum = 0;

    @ApiModelProperty("扣分项")
    private Integer deductNum = 0;

    @ApiModelProperty("加分项")
    private Integer addNum = 0;

    @ApiModelProperty("拒绝项")
    private Integer rejectNum = 0;

    @ApiModelProperty("不合格项数")
    private Integer unqualifiedNum = 0;

    @ApiModelProperty("待整改项列表")
    private List<ModuleGroupDTO> toRepairs;

    @ApiModelProperty("审核中整改项列表")
    private List<ModuleGroupDTO> auditingRepairs;

    @ApiModelProperty("已整改项列表")
    private List<ModuleGroupDTO> repaireds;

    @ApiModelProperty("表单信息")
    private FormDetailVO formDetailVO;

}
