package com.tll.inspect.rpc.vo.report;

/**
 * @author XieBeiChen
 * @date 2025-09-09 17:44
 */

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 个人（如卜柯轩、闵德龙）的巡检明细
 */
@Data
@ApiModel(description = "人员巡检明细信息")
public class PersonInspectionDetail {
    @ApiModelProperty(value = "人员id")
    private Long userId;

    @ApiModelProperty(value = "人员姓名")
    private String userName;

    @ApiModelProperty(value = "巡检报告数")
    private Integer reportNum;

    @ApiModelProperty(value = "巡检店数")
    private Integer storeNum;

    @ApiModelProperty(value = "整改单数量")
    private Integer rectificationOrderNum;

    @ApiModelProperty("开始时间 yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startDateTime;

    @ApiModelProperty("结束时间 yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endDateTime;
}
