package com.tll.inspect.rpc.vo.report;

import com.tll.inspect.rpc.vo.RectificationCategoryChartVO;
import com.tll.inspect.rpc.vo.RectificationOverdueChartVO;
import com.tll.inspect.rpc.vo.RectificationStatusChartVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author XieBeiChen
 * @date 2025-07-09 15:20
 * @description
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SuperviseSubListVO {

    @ApiModelProperty(value = "是否为督查用户")
    private Boolean simpleUserFlag;

    @ApiModelProperty(value = "按分组维度的统计数据")
    private List<InspectionGroupStat> groupStats;

    @ApiModelProperty(value = "人员巡检明细数据")
    private List<PersonInspectionDetail> personDetails;

    @ApiModelProperty(value = "巡检数据趋势分布")
    private List<TrendData> trendDataList;

    @ApiModelProperty("整改状态统计")
    private List<RectificationStatusChartVO> rectificationStatusChart;

    @ApiModelProperty("整改逾期统计")
    private List<RectificationOverdueChartVO> rectificationOverdueChart;

    @ApiModelProperty("整改分类统计")
    private List<RectificationCategoryChartVO> rectificationCategoryChart;

}
