package com.tll.inspect.rpc.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author XieBeiChen
 * @date 2025-08-20 11:52
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ItemExamVO {

    @ApiModelProperty("试卷得分")
    private BigDecimal paperScore;

    @ApiModelProperty("试卷编号")
    private String paperCode;

    @ApiModelProperty("试卷名称")
    private String paperName;

    @ApiModelProperty("三方考试唯一标识")
    private String arrangeId;

    @ApiModelProperty("试卷合格分")
    private BigDecimal paperPassScore;

    @ApiModelProperty("试卷总分")
    private BigDecimal paperTotalScore;

    @ApiModelProperty("用户考试状态: 0：未开始；1：考试中；3：批阅中；4：已完成")
    private Integer paperStatus;

    @ApiModelProperty("巡检考试项状态(1-考试中，2-已完成,3-已取消)")
    private Integer inspectPaperStatus;

    @ApiModelProperty("巡检考试项状态(1-考试中，2-已完成,3-已取消)")
    private Integer inspectPaperStatusName;


    @ApiModelProperty("考试状态名称")
    private String paperStatusName;

    @ApiModelProperty("考试用户ID")
    private String userId;

    @ApiModelProperty("考试用户名称")
    private String userName;

}
