package com.tll.inspect.rpc.vo.library;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

@NoArgsConstructor
@AllArgsConstructor
@Data
public class PictureLibraryRpcVO implements Serializable {

    private static final long serialVersionUID = -2674233759469321279L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("类型(0-巡检报告,1整改单)")
    private Integer libraryType;

    @ApiModelProperty("所属门店")
    private String storeCode;

    @ApiModelProperty("状态(-1上传失败/0上传中/1上传成功)")
    private Integer uploadStatus;

    @ApiModelProperty("上传者id")
    private Long uploader;

    @ApiModelProperty("上传时间")
    private LocalDateTime uploadTime;

    @ApiModelProperty("上传时间")
    private String uploadTimeStr;

    @ApiModelProperty("文件名")
    private String fileName;

    @ApiModelProperty("文件类型（0图片、1视频）")
    private Integer fileType;

    @ApiModelProperty("文件路径")
    private String url;

    @ApiModelProperty("是否被使用（0-未使用，1-已使用）")
    private Boolean used;

}