package com.tll.inspect.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author zhaoshuai
 * @date 2025-06-17
 * @description 巡检图库上传状态
 */
@Getter
@AllArgsConstructor
public enum UploadStatusEnum {

    FAIL(-1, "上传失败"),
    UPLOADING(0, "上传中"),
    SUCCESS(1, "上传成功");

    private final Integer code;
    private final String desc;

    /**
     * 根据编码获取描述
     * @param code 编码
     * @return 描述信息
     */
    public static String getDescByCode(Integer code) {
        for (UploadStatusEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type.getDesc();
            }
        }
        return null;
    }
}
