package com.tll.inspect.rpc.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import java.util.List;

/**
 * @author XieBeiChen
 * @date 2025-06-17 10:47
 * @description
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public  class FormItemVO {
    /**
     * 记录唯一ID
     */
    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    @ApiModelProperty("所属表单记录id")
    @Comment("所属表单记录id")
    @Column(nullable = false)
    private Long employeeTaskRecordId;

    @Comment("排序号")
    @ApiModelProperty("排序号")
    @Column(nullable = false)
    private int sort;

    @Comment("表单项类型：1-单选，2-多选，3-下拉框，4-图片，5-视频，6-文本框，7-量表题，8-定位，9-地址，10-日期，11-门店，12-长文本")
    @ApiModelProperty("表单项类型：1-单选，2-多选，3-下拉框，4-图片，5-视频，6-文本框，7-量表题，8-定位，9-地址，10-日期，11-门店，12-长文本")
    @Column(nullable = false)
    private int type;

    @Comment("标题")
    @ApiModelProperty("标题")
    @Column(nullable = false, length = 128)
    private String title;

    @Comment("填写提示")
    @ApiModelProperty("填写提示")
    @Column(length = 128)
    private String hint;

    @Comment("是否必填：0-否，1-是")
    @ApiModelProperty("是否必填：0-否，1-是")
    @Column(nullable = false, columnDefinition = "int default 0")
    private int isRequired;

    @Comment("是否有填写提示：0-否，1-是")
    @ApiModelProperty("是否有填写提示：0-否，1-是")
    @Column(nullable = false, columnDefinition = "int default 0")
    private int isRemind;

    @Comment("图片是否添加水印：0-否，1-是")
    @ApiModelProperty("图片是否添加水印：0-否，1-是")
    @Column(columnDefinition = "int default null")
    private Integer isImgWatermark;

    @Comment("图片必需数量")
    @ApiModelProperty("图片必需数量")
    @Column(columnDefinition = "int default null")
    private Integer imgNumber;

    @Comment("图片上传规则：0-不限，1-仅限拍照上传")
    @ApiModelProperty("图片上传规则：0-不限，1-仅限拍照上传")
    @Column(columnDefinition = "int default null")
    private Integer imgUploadRule;

    @Comment("视频必需数量")
    @ApiModelProperty("视频必需数量")
    @Column(columnDefinition = "int default null")
    private Integer videoNumber;

    @Comment("定位是否允许修改：0-否，1-是")
    @ApiModelProperty("定位是否允许修改：0-否，1-是")
    @Column(columnDefinition = "int default null")
    private Integer isModifyLocation;

    @Comment("是否为起止日期：0-否，1-是")
    @ApiModelProperty("是否为起止日期：0-否，1-是")
    @Column(columnDefinition = "int default null")
    private Integer isRangeDate;

    @Comment("地址层级：1-省市区详细地址，2-省市区，3-省市，4-省")
    @ApiModelProperty("地址层级：1-省市区详细地址，2-省市区，3-省市，4-省")
    @Column(columnDefinition = "int default null")
    private Integer addressLevel;

    @Comment("量表等级")
    @ApiModelProperty("量表等级")
    @Column(columnDefinition = "int default null")
    private Integer scaleLevel;

    @Comment("是否是数字：0-否，1-是")
    @ApiModelProperty(value = "是否是数字：0-否，1-是")
    @Column(nullable = false, columnDefinition = "int default 0")
    private Integer isNumber;

    @Comment("是否存在图片：0-不存在，1-存在")
    @ApiModelProperty(value = "是否存在图片：0-不存在，1-存在")
    @Column(nullable = false, columnDefinition = "int default 1")
    private Integer existPicture;

    @ApiModelProperty("表单项内容")
    List<EmployeeTaskItemOptionDetailVO> optionsList;

    @ApiModelProperty("前端展示用,拼接字符串")
    String selectValue;

    @ApiModelProperty("表单导出专用字段")
    String exportValue;

    @ApiModelProperty(value = "示例展示方式：1-平铺展示，2-收起展示")
    private Integer describeShowMode;

    /**
     * 示例内容类型：1-自定义，2-关联公告
     */
    @ApiModelProperty(value = "示例内容类型：1-自定义，2-关联公告")
    private Integer describeContentType;

    /**
     * 示例内容
     */
    @ApiModelProperty(value = "示例内容")
    private String describeContent;

    @ApiModelProperty("示例展示内容")
    private String describeShowContent;

    @ApiModelProperty("关联公告名称")
    private String announcementName;

    @Comment("关联此表单项的选项ID列表")
    @ApiModelProperty("关联此表单项的选项ID列表")
    private List<Long> relateOptionId;
}