package com.tll.inspect.rpc.vo;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-07-14 9:32
 * @description
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@Builder
public class ReportAnalysisVO {
    @ApiModelProperty("统计日期,yyyy-MM-dd")
    private String date;

    @ApiModelProperty("报告数")
    private Integer reportCount;

    @ApiModelProperty("合格数")
    private Integer passCount;

    @ApiModelProperty("不合格")
    private Integer unPassCount;

    @ApiModelProperty("不合格(否决)")
    private Integer unPassCountForRejection;

    @ApiModelProperty("不合格(不达标)")
    private Integer unPassCountForNonStandard;

    // @ApiModelProperty("报告id")
    // private List<Long> reportIds;

    @ApiModelProperty("门店编码")
    private List<String> storeCodes;
}
