package com.tll.inspect.rpc.vo.report;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 巡检报告预览巡检项VO
 * @author zhaoshuai
 * @date 2025/6/19
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel(description = "巡检报告预览巡检项VO")
public class ReportOverviewItemVO {

    @ApiModelProperty("整改单明细id")
    private Long rectificationDetailId;

    @ApiModelProperty("整改单id")
    private Long rectOrderId;

    @ApiModelProperty("巡检报告明细id")
    private Long reportItemId;

    @ApiModelProperty("巡检项id")
    private Long itemId;

    @ApiModelProperty("巡检项编号")
    private String itemCode;

    @ApiModelProperty("整改项整改状态")
    private Integer status;

    @ApiModelProperty("是否合格（1-合格，0-不合格）")
    private Boolean passFlag ;

    @ApiModelProperty("项属性")
    private Integer itemProperty;

    @ApiModelProperty("项目内容")
    private String itemName;

    @ApiModelProperty("项排序号")
    private Integer itemSort;

    @ApiModelProperty("评分标准")
    private String scoreStandard;

    @ApiModelProperty("得分")
    private BigDecimal score;

    @ApiModelProperty("巡检模板模块id")
    private Long moduleId;

    @ApiModelProperty("巡检模板模块名")
    private String moduleName;

    @ApiModelProperty("不合格原因")
    private String reason;


    @ApiModelProperty("示例图")
    private List<String> picUrls;

    @ApiModelProperty("不合格返图")
    private List<String> failPicUrls;

    @ApiModelProperty("整改返图")
    private List<String> rectPicUrls;

    @ApiModelProperty("整改项文字说明")
    private String rectDescription;

    @ApiModelProperty("审核状态：-1-待审核，1-通过，0-不通过")
    private Integer auditStatus;

    @ApiModelProperty("整改提交人")
    private String rectificationSubmitter;

    @ApiModelProperty("整改提交人角色")
    private String rectificationSubmitterPosition;

    @ApiModelProperty("整改提交时间")
    private LocalDateTime rectificationSubmitTime;

    @ApiModelProperty("整改提交详情-描述")
    private String rectificationSubmitDetail;

    @ApiModelProperty("整改提交详情-媒体")
    private List<String> rectificationSubmitUrls;


}
