package com.tll.inspect.rpc.vo.travel;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 行程门店
 *
 * @author zhaoshuai
 * @date 2025/6/12
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TravelStoreRpcVO {

    @ApiModelProperty(value = "行程id")
    private Long travelId;

    @ApiModelProperty("行程门店是否已巡（false未巡 true已巡）")
    private Boolean inspected = false;

    @ApiModelProperty(value = "欠款订单编号")
    private String businessOrderNumber;

    @ApiModelProperty(value = "欠款类型名称")
    private String arrearsTypeName;

    @ApiModelProperty(value = "门店ID")
    private String storeName;

    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    @ApiModelProperty(value = "法人姓名")
    private String legalPerson;

    @ApiModelProperty(value = "法人电话")
    private String legalPersonPhone;

    @ApiModelProperty(value = "法人身份证号")
    private String legalPersonIdCard;

    @ApiModelProperty(value = "法人联系地址")
    private String legalPersonAddress;

    @ApiModelProperty(value = "房租（万/年）")
    private String rent;

    @ApiModelProperty(value = "区域经理")
    private String areaManager;

    @ApiModelProperty(value = "门店地址")
    private String storeAddress;

    @ApiModelProperty(value = "运营状态：0：签约、1：营业中、2：短期闭店、3：空合同、4：到期解约、5：长期闭店、7：待装修、8：强制解约、9：其它解约")
    private Integer operationStatus;

    @ApiModelProperty(value = "门店类型：1：加盟店  0：直营店")
    private Integer storeType;

    @ApiModelProperty(value = "省")
    private String province;

    @ApiModelProperty(value = "市")
    private String city;

    @ApiModelProperty(value = "区")
    private String district;

    @ApiModelProperty(value = "登记人")
    private String registrant;

    @ApiModelProperty(value = "sap编码")
    private String sapCode;

    @ApiModelProperty("门店是否已签到")
    private Boolean storeSigned = false;

}
