package com.tll.inspect.rpc.dto.signin;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-06-04 14:43
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SignInRecordDTO extends AbstractOrderQueryParam {

    @ApiModelProperty("签到日期")
    private LocalDate date;

    @ApiModelProperty("签到类型:1-打卡，2-到店签到，3-离店签退")
    private Integer source;

    @ApiModelProperty("仅看无签到人员")
    private Boolean onlyShowNoSignIn;

    @ApiModelProperty("关键字搜索")
    private String keyword;

}
