package com.tll.inspect.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.inspect.Application;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * DEMO服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/29
 */
@FeignClient(name = Application.NAME, path = DemoRpcService.URI)
@Validated
public interface DemoRpcService {
    String URI = Application.URI_PREFIX + "/demo";

    /**
     * 是否已就绪
     *
     * @return 是否已就绪
     */
    @GetMapping(value = "/isReady")
    ApiResult<Boolean> isReady();
}
