package com.tll.inspect.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.inspect.Application;
import com.tll.inspect.rpc.dto.plan.ExecutorsPageDTO;
import com.tll.inspect.rpc.vo.plan.ExecutorsPageVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author XieBeiChen
 * @date 2025-06-05 12:54
 * @description
 */
@FeignClient(name = Application.NAME, path = InspectPlanRpcService.URI)
@Validated
public interface InspectPlanRpcService {

    String URI = Application.URI_PREFIX + "/crossInspectPlan";


    @PostMapping("/pageExecutors")
    @ApiOperation("执行人列表接口")
    ApiResult<PagingVO<ExecutorsPageVO>> pageExecutors(@RequestBody ExecutorsPageDTO dto);

}
