package com.tll.inspect.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.inspect.Application;
import com.tll.inspect.rpc.dto.InspectTemplateQueryDTO;
import com.tll.inspect.rpc.vo.InspectTemplateFormCountVO;
import com.tll.inspect.rpc.vo.InspectTemplateListVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 巡检模板.rpc服务接口
 *
 * @author zhaoshuai
 * @date 2025/5/22
 */
@FeignClient(name = Application.NAME, path = InspectTemplateRpcService.URI)
public interface InspectTemplateRpcService {
    String URI = Application.URI_PREFIX + "/inspectTemplate";

    /**
     * 分页查询表单关联使用的巡检模板
     *
     * @param dto dto.formId 表单id
     */
    @PostMapping(value = "/listForForm")
    @ApiOperation(value = "分页查询表单关联使用的巡检模板")
    ApiResult<PagingVO<InspectTemplateListVO>> listForForm(@RequestBody InspectTemplateQueryDTO dto);

    /**
     * 批量查询表单关联使用的巡检模板数量
     *
     * @param dto dto.formIds 表单id列表
     */
    @PostMapping(value = "/countForForms")
    @ApiOperation(value = "批量查询表单关联使用的巡检模板数量")
    ApiResult<List<InspectTemplateFormCountVO>> countForForms(@RequestBody InspectTemplateQueryDTO dto);


}
