package com.tll.inspect.rpc.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;


/**
 * @author  XieBeiChen
 * @date  2025-06-12 13:44
 * @description
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ReportSendExamDTO implements Serializable {

    @ApiModelProperty(value = "巡检报告ID",required = true)
    @NotNull(message = "巡检报告ID不能为空")
    private Long reportId;

    @NotNull(message = "巡检项id不能为空")
    @ApiModelProperty(value = "巡检项id",required = true)
    private Long itemId;

    @NotBlank(message = "试卷编号不能为空")
    @ApiModelProperty(value = "试卷编号",required = true)
    private String paperCode;

    @ApiModelProperty(value = "考试人员",required = true)
    @NotNull(message = "考试人员不能为空")
    private Long userId;

}
