package com.tll.inspect.rpc.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.time.LocalDate;
import java.util.Set;

/**
 * @author XieBeiChen
 * @date 2025-07-09 15:20
 * @description
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SuperviseSubListDTO {

    @ApiModelProperty(value ="组织id")
    private Long orgId;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty(value = "统计维度：day / week / month /self, 分别代表本日，本周，本月，自定义",required = true)
    @NotBlank(message = "请选择统计维度")
    private String type;

    @ApiModelProperty("开始日期  yyyy-MM-dd")
    private LocalDate startDate;

    @ApiModelProperty("结束时间 yyyy-MM-dd")
    private LocalDate endDate;

    @ApiModelProperty("是否填充缺失的日期,不填默认为true")
    private Boolean fillMissingDates;

}
