package com.tll.inspect.rpc.dto.plan;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 交叉巡店计划列表查询-B端
 *
 * @author 齐燊登
 * @date 2025/06/05
 */
@Data
@ApiModel(description = "交叉巡店计划列表查询-B端")
public class CrossInspectPlanBackstagePageDTO extends AbstractExportQueryParam {
    @ApiModelProperty(value = "计划执行人")
    private String executorName;

//    @ApiModelProperty(value = "部门信息")
//    private String departmentInfo;

//    @ApiModelProperty(value = "员工岗位")
//    private List<String> employeePosition;

    @ApiModelProperty(value = "执行人部门id")
    private List<String> executeUserDeptId;

    @ApiModelProperty(value = "执行人岗位")
    private List<String> executeUserPositionName;

    @ApiModelProperty(value = "计划创建人")
    private String planCreator;

    @ApiModelProperty(value = "门店法人")
    private String storeLegalPerson;

    @ApiModelProperty(value = "行程开始时间 - 开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime itineraryStartDateStart;

    @ApiModelProperty(value = "行程开始时间 - 结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime itineraryStartDateEnd;

    @ApiModelProperty(value = "行程结束时间 - 开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime itineraryEndDateStart;

    @ApiModelProperty(value = "行程结束时间 - 结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime itineraryEndDateEnd;

    @ApiModelProperty(value = "行程创建时间 - 开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime itineraryCreateTimeStart;

    @ApiModelProperty(value = "行程创建时间 - 结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime itineraryCreateTimeEnd;

    @ApiModelProperty(value = "门店信息")
    private String storeInfo;

    @ApiModelProperty(value = "行程计划状态: EXPIRED-已过期, EFFECTIVE-生效中, PENDING-待生效")
    private String planStatus;
    
}

