package com.tll.inspect.rpc.dto.plan;

import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-05-30 16:54
 * @description
 */

@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class InspectPlanEditDTO {

    @ApiModelProperty(value = "计划ID",required = true)
    @NotNull(message = "计划ID不能为空")
    private Long id;

    @ApiModelProperty(value = "开始日期",required = true)
    @NotNull(message = "开始时间不能为空")
    private LocalDate startDate;

    @ApiModelProperty(value = "结束日期",required = true)
    @NotNull(message = "结束时间不能为空")
    private LocalDate endDate;

    @ApiModelProperty(value = "执行人ID",required = true)
    @NotNull(message = "执行人ID不能为空")
    private Long executorId;

    @ApiModelProperty(value = "门店ID",required = true)
    @NotEmpty(message = "请至少选择一家门店")
    private List<String> storeCodes;

    @ApiModelProperty(value = "本期必到门店数",required = true)
    @NotNull(message = "本期必到门店数不能为空")
    private Integer requiredStoreCount;

}