package com.tll.inspect.rpc.dto.plan;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-06-04 13:42
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class InspectPlanPageDTO extends AbstractOrderQueryParam {

    @ApiModelProperty("执行人ID")
    private Long executorId;

    @ApiModelProperty("省ID列表")
    private List<String> province;

    @ApiModelProperty("市ID列表")
    private List<String> city;

    @ApiModelProperty("区ID列表")
    private List<String> district;

    @ApiModelProperty("是否30天未巡")
    private Boolean onlyNoThirty;

    @ApiModelProperty(value = "行程时间(开始日期)")
    private LocalDate startDate;

    @ApiModelProperty(value = "行程时间(结束日期)")
    private LocalDate endDate;

    @ApiModelProperty(value = "行程日期")
    private LocalDate travelDate;

    @ApiModelProperty("是否活动到店")
    private Boolean activityArrived;

}
