package com.tll.inspect.rpc.dto.plan;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author XieBeiChen
 * @date 2025-06-04 13:42
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class InspectPlanPageWithSimpleDTO extends AbstractOrderQueryParam {

    @ApiModelProperty("执行人ID")
    private Long executorId;

    //员工姓名
    @ApiModelProperty(value = "员工姓名")
    private String fullName;

    @ApiModelProperty(value = "计划状态: EXPIRED-已过期, EFFECTIVE-生效中, PENDING-待生效")
    private List<String> planStatusList;

    @ApiModelProperty(value = "行程时间(开始日期)")
    @NotNull(message = "开始时间不能为空")
    private LocalDate startDate;

    @ApiModelProperty(value = "行程时间(结束日期)")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束时间不能为空")
    private LocalDate endDate;

    @ApiModelProperty(value = "创建时间(开始日期)")
    @NotNull(message = "开始时间不能为空")
    private LocalDate createTimeStart;

    @ApiModelProperty(value = "创建时间(结束日期)")
    @NotNull(message = "结束时间不能为空")
    private LocalDate createTimeEnd;
}
