package com.tll.inspect.rpc.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;

/**
 * @author XieBeiChen
 * @date 2025-06-04 14:43
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SignInViewVO implements Serializable {

    @ApiModelProperty("签到数据")
    private List<SignItem> signItems;

    @NoArgsConstructor
    @AllArgsConstructor
    @Data
    public static class SignItem{
        @ApiModelProperty("日期")
        private String date;

        @ApiModelProperty("签到标识")
        private Boolean signFlag;

        @ApiModelProperty("记录创建时间")
        private LocalDateTime createTime;

        @ApiModelProperty("请假标识")
        private Boolean vacationFlag;

        @ApiModelProperty("打卡数据来源:1-打卡，2-到店签到，3-离店签退")
        private Integer source;

        @ApiModelProperty("是否迟到")
        private Boolean late;

        @ApiModelProperty("签到开始时间,用来衡量是否迟到")
        private LocalDateTime signStartTime ;

    }

}
