package com.tll.inspect.rpc.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author XieBeiChen
 * @date 2025-07-11 16:01
 * @description
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class UserInspectReportStatsVO {
    private Long id;

    @ApiModelProperty("是否合格（1-合格，0-不合格）")
    private Boolean passFlag;

    @ApiModelProperty("门店编号")
    private String storeCode;

    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @ApiModelProperty("提交时间")
    private LocalDateTime commitTime;

    @ApiModelProperty("不合格类型（0-无，1-否决项不合格）")
    private Integer unqualifiedType ;

    @ApiModelProperty(value = "巡检总分（包含加分项、减分项）")
    private BigDecimal totalScore;

    @ApiModelProperty("巡检报告得分")
    private BigDecimal score;

    @ApiModelProperty(value = "模版合格分数")
    private BigDecimal passScore;


}
