package com.tll.inspect.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.inspect.Application;
import com.tll.inspect.rpc.dto.InspectReportDetailQueryRpcDTO;
import com.tll.inspect.rpc.dto.ReportSubListDTO;
import com.tll.inspect.rpc.dto.StoreTimeQueryRpcDTO;
import com.tll.inspect.rpc.dto.SuperviseSubListDTO;
import com.tll.inspect.rpc.vo.ReportSubListVO;
import com.tll.inspect.rpc.vo.report.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 巡检报告rpc服务（C端）
 */
@FeignClient(name = Application.NAME, path = InspectReportRpcService.URI)
@Validated
public interface InspectReportRpcService {

    String URI = Application.URI_PREFIX + "/report";

    @PostMapping("/pageList")
    @ApiOperation("巡检报告列表")
    ApiResult<PagingVO<InspectReportListRpcVO>> pageList(@RequestBody InspectReportListQueryRpcDTO dto);

    @PostMapping("/queryReportOverview")
    @ApiOperation("巡检报告概览")
    ApiResult<InspectReportOverViewRpcVO> queryReportOverview(@RequestBody InspectReportDetailQueryRpcDTO dto);

    @PostMapping("/queryReportDetail")
    @ApiOperation("巡检报告详情")
    ApiResult<InspectReportDetailRpcVO> queryReportDetail(@RequestBody InspectReportDetailQueryRpcDTO rpcDTO);


    @PostMapping("/rectificationStatistics")
    @ApiOperation("整改统计图表")
    ApiResult<ReportSubListVO> rectificationStatistics(@RequestBody ReportSubListDTO rpcDTO);

    @PostMapping("/queryUnqualifiedRank")
    @ApiOperation("巡检项不合格排行")
    ApiResult<ReportSubListVO> queryUnqualifiedRank(@RequestBody ReportSubListDTO rpcDTO);

    @PostMapping("/querySuperviseRectificationStatistics")
    @ApiOperation("督查统计 - 整改统计、分类统计")
    ApiResult<SuperviseSubListVO> querySuperviseRectificationStatistics(@RequestBody SuperviseSubListDTO rpcDTO);

    @PostMapping("/queryStoreTime")
    @ApiOperation("根据门店编码查询最近一次巡检时间和报货时间")
    ApiResult<StoreTimeRpcVO> queryStoreTime(@RequestBody StoreTimeQueryRpcDTO rpcDTO);

}