package com.tll.inspect.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.inspect.Application;
import com.tll.inspect.rpc.dto.ReportConfirmDataDTO;
import com.tll.inspect.rpc.dto.ReportSaveDraftDTO;
import com.tll.inspect.rpc.dto.ReportSubmitDTO;
import com.tll.inspect.rpc.dto.ReportTemplateConfirmDTO;
import com.tll.inspect.rpc.dto.ReportTemplateItemPageDTO;
import com.tll.inspect.rpc.dto.ReportTemplatePageDTO;
import com.tll.inspect.rpc.vo.ReportConfirmVO;
import com.tll.inspect.rpc.vo.ReportSubmitVO;
import com.tll.inspect.rpc.vo.ReportTemplateConfirmVO;
import com.tll.inspect.rpc.vo.ReportTemplateItemPageVO;
import com.tll.inspect.rpc.vo.ReportTemplatePageVO;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author XieBeiChen
 * @date 2025-06-05 11:23
 * @description
 */
@FeignClient(name = Application.NAME, path = ReportRpcService.URI)
public interface ReportRpcService {

    String URI = Application.URI_PREFIX + "/report";


    @PostMapping("template/page")
    @ApiOperation("巡检模板列表")
    ApiResult<PagingVO<ReportTemplatePageVO>> templatePage(@RequestBody ReportTemplatePageDTO dto);

    @PostMapping("template/confirm")
    @ApiOperation("确认巡检模板")
    ApiResult<ReportTemplateConfirmVO> templateConfirm(@Valid @RequestBody ReportTemplateConfirmDTO dto) ;

    @PostMapping("/template/items")
    @ApiOperation("巡检模板详情")
    ApiResult<PagingVO<ReportTemplateItemPageVO>> templateItems(@Valid @RequestBody ReportTemplateItemPageDTO dto) ;

    @PostMapping("/saveDraft")
    @ApiOperation("报告暂存")
    ApiResult<Void> saveDraft(@Valid @RequestBody ReportSaveDraftDTO dto);

    @PostMapping("/confirmData")
    @ApiOperation("获取报告确认页面内容")
    ApiResult<ReportConfirmVO> confirmData(@Valid @RequestBody ReportConfirmDataDTO dto) ;

    @PostMapping("/submit")
    @ApiOperation("报告提交")
    ApiResult<ReportSubmitVO> submit(@Valid @RequestBody ReportSubmitDTO dto) ;
}
