package com.tll.inspect.rpc.dto;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * @author  XieBeiChen
 * @date  2025-06-12 13:44
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ReportTemplateConfirmDTO implements Serializable {

    @ApiModelProperty(value = "行程Id",required = true)
    @NotNull(message = "行程Id不能为空")
    private Long travelId;

    @ApiModelProperty(value = "巡检任务id",required = true)
    @NotNull(message = "巡检任务id不能为空")
    private String inspectTaskId;

    @ApiModelProperty(value = "模板id",required = true)
    @NotNull(message = "模板id不能为空")
    private Long templateId;

    @ApiModelProperty(value = "店铺编码",required = true)
    @NotBlank(message = "店铺编码不能为空")
    private String storeCode;

    @ApiModelProperty("报告id,切换模板的时候必填")
    private Long reportId;
}
