package com.tll.inspect.rpc.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 门店时间查询RPC DTO
 * 根据门店编码查询最近一次巡检时间和报货时间
 *
 * @author auto-generated
 * @date 2025/01/XX
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class StoreTimeQueryRpcDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotBlank(message = "门店编码不能为空")
    @ApiModelProperty(value = "门店编码", required = true)
    private String storeCode;

}

