package com.tll.inspect.rpc.dto.communication;

import com.tll.inspect.rpc.dto.media.MediaDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 沟通记录保存参数
 *
 * @author Jxinx
 * @since 2025-07-12
 */
@Data
@ApiModel("沟通记录保存参数")
public class CommunicationRecordsSaveRpcDTO implements Serializable {

    private static final long serialVersionUID = -6859459890434656320L;

    @ApiModelProperty("门店编码")
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    @ApiModelProperty("巡检任务编码")
    private String inspectTaskNumber;

    @ApiModelProperty("沟通渠道（UDC巡检/线下/微信/电话/其他）")
    private String channel;

    @ApiModelProperty("沟通时间")
    private LocalDateTime communicationTime;

    @ApiModelProperty("附件列表")
    private List<MediaDTO> fileUrls;

    @ApiModelProperty("沟通内容")
    @NotBlank(message = "沟通内容不能为空")
    private String content;
}
