package com.tll.inspect.rpc.dto.travel;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 行程审核流结果接收对象
 * @author zhaoshuai
 * @date 2025/8/11
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TravelProcessReceiveRpcDTO implements Serializable {

    private static final long serialVersionUID = 671398698469104979L;

    @ApiModelProperty("流程id")
    private String processId;

    @ApiModelProperty("审核状态（-1无/未提交 0审核中 1审核通过 2审核驳回 3撤回 4 作废）")
    private Integer auditStatus;

    @ApiModelProperty("行程id")
    private Long travelId;

    @ApiModelProperty("是否需要审核")
    private Boolean needAudit;


}
