/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.base;

import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.common.base.ApiCode;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

public class ServiceResult<T>
implements Serializable {
    private static final long serialVersionUID = -3334680109760960253L;
    private int code;
    private String msg;
    private boolean success;
    private T data;
    private LocalDateTime time = LocalDateTime.now();

    public ServiceResult() {
    }

    public static <T> ServiceResult<T> result(boolean flag) {
        if (flag) {
            return ServiceResult.ok();
        }
        return ServiceResult.fail();
    }

    public static <T> ServiceResult<T> result(ApiCode apiCode) {
        return ServiceResult.result(apiCode, null);
    }

    public static <T> ServiceResult<T> result(ApiCode apiCode, T data) {
        return ServiceResult.result(apiCode, null, data);
    }

    public static <T> ServiceResult<T> result(ApiCode apiCode, String msg, T data) {
        boolean success = false;
        if (apiCode.getCode() == ApiCode.SUCCESS.getCode()) {
            success = true;
        }
        String message = apiCode.getMsg();
        if (StrUtil.isNotBlank((CharSequence)msg)) {
            message = msg;
        }
        return ServiceResult.builder().code(apiCode.getCode()).msg(message).data(data).success(success).time(LocalDateTime.now()).build();
    }

    public static <T> ServiceResult<T> ok() {
        return ServiceResult.ok(null);
    }

    public static <T> ServiceResult<T> ok(T data) {
        return ServiceResult.result(ApiCode.SUCCESS, data);
    }

    public static <T> ServiceResult<T> ok(T data, String msg) {
        return ServiceResult.result(ApiCode.SUCCESS, msg, data);
    }

    public static <T> ServiceResult<Map<String, T>> okMap(String key, T value) {
        HashMap<String, T> map = new HashMap<String, T>(1);
        map.put(key, value);
        return ServiceResult.ok(map);
    }

    public static Map<String, Object> toMap(ServiceResult<?> result) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", result.code);
        map.put("msg", result.msg);
        map.put("data", result.data);
        map.put("success", result.success);
        map.put("time", result.time);
        return map;
    }

    public static <T> ServiceResult<T> fail(ApiCode apiCode) {
        return ServiceResult.result(apiCode, null);
    }

    public static <T> ServiceResult<T> fail(String msg) {
        return ServiceResult.result(ApiCode.FAIL, msg, null);
    }

    public static <T> ServiceResult<T> fail(ApiCode apiCode, T data) {
        if (ApiCode.SUCCESS == apiCode) {
            throw new RuntimeException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a" + ApiCode.SUCCESS.getCode());
        }
        return ServiceResult.result(apiCode, data);
    }

    public static <T> ServiceResult<Map<String, T>> fail(String key, T value) {
        HashMap<String, T> map = new HashMap<String, T>(1);
        map.put(key, value);
        return ServiceResult.result(ApiCode.FAIL, map);
    }

    public static <T> ServiceResult<T> fail() {
        return ServiceResult.fail(ApiCode.FAIL);
    }

    public static <T> ServiceResultBuilder<T> builder() {
        return new ServiceResultBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public T getData() {
        return this.data;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public ServiceResult<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public ServiceResult<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public ServiceResult<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public ServiceResult<T> setData(T data) {
        this.data = data;
        return this;
    }

    public ServiceResult<T> setTime(LocalDateTime time) {
        this.time = time;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceResult)) {
            return false;
        }
        ServiceResult other = (ServiceResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        LocalDateTime this$time = this.getTime();
        LocalDateTime other$time = other.getTime();
        return !(this$time == null ? other$time != null : !((Object)this$time).equals(other$time));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        LocalDateTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        return result;
    }

    public String toString() {
        return "ServiceResult(code=" + this.getCode() + ", msg=" + this.getMsg() + ", success=" + this.isSuccess() + ", data=" + this.getData() + ", time=" + this.getTime() + ")";
    }

    public ServiceResult(int code, String msg, boolean success, T data, LocalDateTime time) {
        this.code = code;
        this.msg = msg;
        this.success = success;
        this.data = data;
        this.time = time;
    }

    public static class ServiceResultBuilder<T> {
        private int code;
        private String msg;
        private boolean success;
        private T data;
        private LocalDateTime time;

        ServiceResultBuilder() {
        }

        public ServiceResultBuilder<T> code(int code) {
            this.code = code;
            return this;
        }

        public ServiceResultBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public ServiceResultBuilder<T> success(boolean success) {
            this.success = success;
            return this;
        }

        public ServiceResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public ServiceResultBuilder<T> time(LocalDateTime time) {
            this.time = time;
            return this;
        }

        public ServiceResult<T> build() {
            return new ServiceResult<T>(this.code, this.msg, this.success, this.data, this.time);
        }

        public String toString() {
            return "ServiceResult.ServiceResultBuilder(code=" + this.code + ", msg=" + this.msg + ", success=" + this.success + ", data=" + this.data + ", time=" + this.time + ")";
        }
    }
}

