package com.elitesland.inv.dto.invlot.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 08月 18日 17:13
 * @version: 1.0
 */
@Data
public class InvLotCommonRpcDtoParam implements Serializable {

    private static final long serialVersionUID = -1290710563634437089L;

    @ApiModelProperty(value = "公司ID")
    @NotNull(message = "公司ID不能为空")
    private List<Long> ouIds;

    @ApiModelProperty(value = "公司ID")
    @NotNull(message = "商品ID不能为空")
    private List<Long> itemIds;

    @ApiModelProperty(value = "公司ID")
    @NotEmpty(message = "批号不能为空")
    private List<String> lotNos;



}
