package com.elitesland.inv.provider;

import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invTrn.InvTrnResultRpcDTO;
import com.elitesland.inv.dto.invTrn.InvTrnSaveRpcDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author jeesie
 * @date 2022-05-18
 * <p>
 *     库存转移
 * </>
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvTrnProvider.PATH)
public interface InvTrnProvider {
    String PATH = "/invTrn";
    /**
     * 保存提交库存转移单
     * @param invTrnSaveRpcDTO
     * @return
     */
    @PostMapping("/submitInvTrn")
    ApiResult<InvTrnResultRpcDTO> submitInvTrn(@RequestBody InvTrnSaveRpcDTO invTrnSaveRpcDTO);

    /**
     * 审核库存转移单
     * @param masId
     * @return
     */
    @PostMapping("/checkInvTrn")
    Long checkInvTrn(@RequestParam("masId") Long masId);

    /**
     * 库存转移移库确认
     */
    @PostMapping("/confirmInvTrn")
    Long confirmInvTrn(@RequestParam("masId") Long masId);

    /**
     * 收货确认
     */
    @PostMapping("/recvConfirmInvTrn")
    Long recvConfirmInvTrn(@RequestParam("masId") Long masId);




}
