package com.elitesland.inv.dto.ido;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "InvIdoSaveVO", description = "库存入库单保存")
public class InvIdoSaveRpcDTO implements Serializable {
    private static final long serialVersionUID = -1288939798948998849L;
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("单据日期")
    private LocalDateTime docDate;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("单据状态 [UDC]ODO:ODO_STATUS")
    private String docStatus;

    @ApiModelProperty("发货时间")
    private LocalDateTime shipmentDate;

    @ApiModelProperty("要求发货时间")
    private LocalDateTime demandDate;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("业务员员工ID")
    private Long agentEmpId;

    @ApiModelProperty("业务员员工编号")
    private String agentEmpCode;

    @ApiModelProperty("业务员名")
    private String agentEmpName;

    @ApiModelProperty("配送方式 [UDC]SAL:SO_DELIVER_METHOD")
    private String deliverMethod;

    @ApiModelProperty("承运信息")
    private String deliveryDesc;

    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;

    @ApiModelProperty("签收用户ID")
    private Long confirmUserId;

    @ApiModelProperty("签收人")
    private String confirmUserName;

    @ApiModelProperty("收货地址号")
    private String recvAddrNo;

    @ApiModelProperty("收货地址联系人")
    private String recvContactName;

    @ApiModelProperty("收货地址电话")
    private String recvContactTel;

    @ApiModelProperty("收货联系人邮箱")
    private String recvContactEmail;

    @ApiModelProperty("收货国家")
    private String recvCountry;

    @ApiModelProperty("收货省")
    private String recvProvince;

    @ApiModelProperty("收货市")
    private String recvCity;

    @ApiModelProperty("收货区县")
    private String recvCounty;

    @ApiModelProperty("收货乡镇街道")
    private String recvStreet;

    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    @ApiModelProperty("关联单据类别")
    private String relateDocCls;

    @ApiModelProperty("关联单据ID")
    private Long relateDocId;

    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("关联单据2类别")
    private String relateDoc2Cls;

    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;

    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;

    @ApiModelProperty("关联单据3类别")
    private String relateDoc3Cls;

    @ApiModelProperty("关联单据3ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc3Id;

    @ApiModelProperty("关联单据3编号")
    private String relateDoc3No;

    @ApiModelProperty("限定1")
    private String deter1;

    @ApiModelProperty("限定3")
    private String deter3;

    @ApiModelProperty("限定4")
    private String deter4;

    @ApiModelProperty("接口状态")
    private String intfStatus;

    @ApiModelProperty("接口时间")
    private LocalDateTime intfTime;

    @ApiModelProperty("是否走接口")
    private Boolean intfFlag;

    @ApiModelProperty("文件编码")
    private String fileCode;

    @ApiModelProperty("团内/团外")
    private Boolean scene;

    @ApiModelProperty("ES1")
    private String es1;

    @ApiModelProperty("ES2")
    private String es2;

    @ApiModelProperty("ES3")
    private String es3;

    @ApiModelProperty("审批时间")
    private LocalDateTime apprTime;

    @ApiModelProperty("审批人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long apprUserId;

    @ApiModelProperty("审批人名")
    private String apprUserName;

    @ApiModelProperty("来源系统")
    private String es5;

    @ApiModelProperty("承运商")
    private String carrier;

    @ApiModelProperty("单据明细")
    private List<InvIdoDSaveRpcDTO> idoDSaveRpcDTOS;

    @ApiModelProperty("物流单号")
    private String logisDocNo;

    @ApiModelProperty("物流公司编号")
    private String logisCarrierCode;

    @ApiModelProperty("物流公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long logisCarrierId;

    @ApiModelProperty("物流公司名称")
    private String logisCarrierName;

    @ApiModelProperty("物流配送人")
    private String logisContactName;
    /**
     * 配送人联系方式
     */
    @ApiModelProperty("配送人联系方式")
    private String logisContactTel;

    @ApiModelProperty("物流费用")
    private BigDecimal logisFee;
}
