package com.elitesland.inv.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.odo.InvOdoSaveRpcDTO;
import com.elitesland.inv.dto.odo.InvSignOdoRpcDtoParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author jeesie
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvOdoProvider.PATH)
public interface InvOdoProvider {
    String PATH = "/invOdoProvider";

    /**
     * 创建出库单
     * 单据状态为草稿
     * @param invOdoSaveRpcDTO
     * @return
     */
    @PostMapping("/saveInvOdo")
    ApiResult<String> saveInvOdo(@RequestBody InvOdoSaveRpcDTO invOdoSaveRpcDTO);

    /**
     * 签收出库单
     * @param signOdoRpcDtoParam
     * @return
     */
    @PostMapping("/signInvOdo")
    ApiResult<Boolean> signInvOdo(@RequestBody InvSignOdoRpcDtoParam signOdoRpcDtoParam);



}
